#include <iostream>
#include <algorithm>
using namespace std;

// Structure to store job details
struct Job {
    char id;     // Job ID
    int deadline; 
    int profit;
};

// Comparison function to sort jobs by decreasing profit
bool compare(Job a, Job b) {
    return a.profit > b.profit;
}

int main() {
    int n;
    cout << "Enter the number of jobs: ";
    cin >> n;

    Job jobs[n];
    cout << "Enter Job ID, Deadline, and Profit for each job:\n";
    for (int i = 0; i < n; i++) {
        cin >> jobs[i].id >> jobs[i].deadline >> jobs[i].profit;
    }

    // Step 1: Sort jobs in descending order of profit
    sort(jobs, jobs + n, compare);

    // Step 2: Find maximum deadline
    int maxDeadline = 0;
    for (int i = 0; i < n; i++)
        maxDeadline = max(maxDeadline, jobs[i].deadline);

    // Step 3: Create a slot array to keep track of free time slots
    char jobSequence[maxDeadline + 1];
    bool slot[maxDeadline + 1];
    for (int i = 0; i <= maxDeadline; i++)
        slot[i] = false;

    // Step 4: Schedule jobs
    int totalProfit = 0;
    for (int i = 0; i < n; i++) {
        // Find a free slot for this job (starting from its deadline)
        for (int j = jobs[i].deadline; j > 0; j--) {
            if (slot[j] == false) {
                slot[j] = true;
                jobSequence[j] = jobs[i].id;
                totalProfit += jobs[i].profit;
                break;
            }
        }
    }

    // Step 5: Display result
    cout << "\nSelected Job Sequence: ";
    for (int i = 1; i <= maxDeadline; i++) {
        if (slot[i])
            cout << jobSequence[i] << " ";
    }

    cout << "\nTotal Profit: " << totalProfit << endl;

    return 0;
}
